/*
 * CarregaLocalsPendents.java
 *
 * Created on 29 de mayo de 2008, 0:17
 */

package servlets;

import java.io.*;
import java.net.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.DataSource;
import locals.Local;
import org.apache.tools.ant.taskdefs.condition.IsSet;
/**
 *
 * @author Administrador
 * @version
 */
public class CarregaLocalsPendents extends HttpServlet {
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    
    Connection con = null;
    DataSource ds = null;
    ArrayList <Local> localsPendents = new ArrayList();
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        
        try {
            Context contextoInicial = new InitialContext();
            Context contexto = (Context) contextoInicial.lookup("java:comp/env");
            
            ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria");
            con = ds.getConnection();
            Statement st = con.createStatement();
            
            if ( request.getParameter("idLocal") != null) {
                Local local = new Local();
                
                //Consulta per saber el tipus, superficie, caracteristiques i preu
                ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE id_local = "+ request.getParameter("idLocal"));
                rs.next();
                local.setTipus(rs.getString("tipus"));
                local.setSuperficie(rs.getFloat("superficie"));
                local.setCaracteristiques(rs.getString("caracteristiques"));
                local.setPreu(rs.getFloat("preu"));
                rs.close();
                
                
                if (local.getTipus().equals("botiga_magatzem")) {
                    rs = st.executeQuery("SELECT * FROM botigues_magatzem WHERE id_local = "+local.getIdLocal());
                    while (rs.next())
                        local.setVolum(rs.getFloat("volum"));
                    rs.close();
                    
                } else if (local.getTipus().equals("polivalent")){
                    rs = st.executeQuery("SELECT * FROM polivalents WHERE id_local = "+local.getIdLocal());
                    while (rs.next())
                        local.setCaracteristiquesPolivalents("caracteristiques_polivalent");
                    rs.close();
                }
                
                rs = st.executeQuery("SELECT id_local, adresa FROM locals AS a JOIN adreses AS b ON a.id_adresa = b.id_adresa WHERE actiu = 0");
                while ( rs.next() ) {
                    local.setAdresa(rs.getString("adresa"));
                }
                rs.close();
                
                request.setAttribute("Local", local);
                
            } else {
                request.getSession().removeAttribute("localsPendents");
                ResultSet rs = st.executeQuery("SELECT id_local, adresa FROM locals AS a JOIN adreses AS b ON a.id_adresa = b.id_adresa WHERE actiu = 0");
                while ( rs.next() ) {
                    localsPendents.add(new Local(rs.getInt("id_local"), rs.getString("adresa") ));
                }
                rs.close();
                st.close();
                request.getSession().setAttribute("localsPendents",localsPendents);
            }
        } catch(Exception e) {
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception ex){}
        }
        
        //redirigim cap a l'altra pagina
        RequestDispatcher rD = request.getRequestDispatcher("/localsPendents.jsp");
        rD.forward(request, response);
        
        out.close();
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
